<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */

# функция автоподключения плагина
function submit_article_autoload($args = array())
{	
	# Определяем опции для управления правами доступа к плагину
	mso_create_allow(basename(dirname(__FILE__)).'_options', 'Админ-доступ к опциям плагина «Прислать статью»');
	mso_create_allow(basename(dirname(__FILE__)).'_edit', 'Админ-доступ к плагину «Прислать статью»');
		
	mso_hook_add('admin_init', basename(dirname(__FILE__)).'_admin_init');  # хук для подключения плагина в меню админки
	mso_hook_add('admin_head', basename(dirname(__FILE__)).'_admin_head'); # хук для подключения стилей на внутренних страницах
		
	mso_hook_add('head', basename(dirname(__FILE__)).'_head'); # хук для подключения стилей на внешних страницах
	mso_hook_add('custom_page_404', basename(dirname(__FILE__)).'_custom_page_404'); # хук для подключения к шаблону и обработке внешнего slug-а
		
	mso_hook_add('mso_email_message_new_comment', basename(dirname(__FILE__)).'_notify_new_comment'); # хук для рассылки авторам уведомлений о новых комментариях к их статьям
		
	mso_hook_add('users_add_out', basename(dirname(__FILE__)).'_users_add_out'); # хук для подключения списка публикаций комюзера
		
	# получаем опции
	$options = submit_article_get_options();
		
	if( isset($options['show_author_info']) && $options['show_author_info'] && isset($options['show_author_info_hook']) && $options['show_author_info_hook'] <> '' ) # хук для авторского блока
	{
		$par = explode('|', $options['show_author_info_hook']);
		mso_hook_add($par[0], basename(dirname(__FILE__)).'_author_box', (isset($par[1])? $par[1] : 10));
	}
		
	if( isset($options['widget_mode']) && $options['widget_mode'] ) # подключение виджета при необходимости
	{
		mso_register_widget(basename(dirname(__FILE__)).'_widget', 'Прислать статью');  # регистрируем виджет
	}
	else
	{
		global $MSO;
		if( isset($MSO->widgets[basename(dirname(__FILE__)).'_widget']) )
		{
			unset($MSO->widgets[basename(dirname(__FILE__)).'_widget']);
		}
	}
}

# функция выполняется при активации (вкл) плагина
function submit_article_activate($args = array())
{
	return $args;
}

# функция выполняется при деактивации (выкл) плагина
function submit_article_deactivate($args = array())
{	
	return $args;
}

# функция выполняется при деинсталяции плагина
function submit_article_uninstall($args = array())
{
	# удалим созданные опции
	mso_delete_option(basename(dirname(__FILE__)).'_article', 'plugins');
		
	# удалим созданные разрешения
	mso_remove_allow(basename(dirname(__FILE__)).'_edit');
	mso_remove_allow(basename(dirname(__FILE__)).'_options');
		
	# удалим созданные опции виджета
	mso_delete_option_mask(basename(dirname(__FILE__)).'_widget_', 'plugins');
		
	return $args;
}

# функция выполняется при указаном хуке admin_init
function submit_article_admin_init($args = array()) 
{	
	if( !mso_check_allow(basename(dirname(__FILE__)).'_edit') ) 
	{
		return $args;
	}
		
	mso_admin_menu_add('plugins', basename(dirname(__FILE__)), 'Прислать статью');
	mso_admin_url_hook(basename(dirname(__FILE__)), basename(dirname(__FILE__)).'_admin');
		
	# получаем опции
	$options = submit_article_get_options();
		
	if( isset($options['widget_mode']) && !$options['widget_mode'] ) # отключение виджета при необходимости
	{
		if( mso_segment(1) == 'admin' && mso_segment(2) == 'sidebars' )
		{		
			global $MSO, $cache_options;
				
			if( $MSO->sidebars )
			{
				foreach( $MSO->sidebars as $name => $sidebar )
				{
					$widgets = mso_get_option('sidebars-'.mso_slug($name), 'sidebars', array());
						
					$key = array_search(basename(dirname(__FILE__)).'_widget', $widgets);
					if( $key )
					{
						unset($widgets[$key]);
						if( isset($cache_options['sidebars']['sidebars-'.mso_slug($name)]) )
						{
							$cache_options['sidebars']['sidebars-'.mso_slug($name)] = '_serialize_'.serialize($widgets);
						}
					}
				}
			}
		}
	}
		
	return $args;
}

# функция подключения дополнительных стилей и скриптов для работы плагина в админке
function submit_article_admin_head($args = array())
{
	echo NR.'<!-- плагин '.basename(dirname(__FILE__)).' -->'.NR;
		
	if( mso_segment(1) == 'admin' )
	{
		# Стили	
		echo '
			<style>
				div.sidebar ul.admin-menu ul.admin-submenu li.admin-menu-'.basename(dirname(__FILE__)).' a:before {
					content: "\f044";
				}
			</style>
		';
	}
		
	if( mso_segment(1) == 'admin' && ( mso_segment(3) == basename(dirname(__FILE__)) || mso_segment(2) == basename(dirname(__FILE__)) ) )
	{
		# общие стили для админ-панели
		echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/admin.css" type="text/css" media="screen">'.NR;
			
		# Подключение необходимого на странице опций плагина
		# admin/plugin_options/submit_article
		if( mso_segment(2) == 'plugin_options' )
		{
			# стили для страницы опций
			if( $fn = mso_fe('backend-options.css', getinfo('plugins_dir').basename(dirname(__FILE__)).'/') ) echo mso_load_style( getinfo('plugins_url').basename(dirname(__FILE__)).'/backend-options.css' );
			
			# скрипта видимости некоторых опций на странице настройки плагина
			echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/js/admin.options.js"></script>'.NR; # подключаем js для админки
		}
			
		if( mso_segment(2) == basename(dirname(__FILE__)) )
		{
			# Куда отправлять AJAX-запросы
			$ajax_path = getinfo('ajax').base64_encode('plugins/'.basename(dirname(__FILE__)).'/do-ajax.php');
			echo "
				<script type=\"text/javascript\">
					var ajax_path = '".$ajax_path."'
				</script>
			";
				
			# jQuery код для кнопок
			echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/js/admin.panel.js"></script>'.NR; # подключаем js для админки
		}
	}
		
	echo NR.'<!-- /плагин '.basename(dirname(__FILE__)).' -->'.NR;
		
	return $args;
}


# функция вызываемая при хуке, указанном в mso_admin_url_hook
function submit_article_admin($args = array()) 
{
	if( !mso_check_allow(basename(dirname(__FILE__)).'_edit') ) 
	{
		echo 'Доступ запрещен';
		return $args;
	}
	# получаем опции
	$options = submit_article_get_options();
		
	# если опции ещё не заданы
	if( count($options) == 0 )
	{
		mso_redirect('admin/plugin_options/'.basename(dirname(__FILE__))); # перебрасываем на страницу настройки опций
	}
		
	# выносим админские (backend) функции в отдельный файл
	require(getinfo('plugins_dir').basename(dirname(__FILE__)).'/backend-admin.php');
}
	
# формирование страницы опций в админке
function submit_article_mso_options()
{
	if( !mso_check_allow(basename(dirname(__FILE__)).'_options') )
	{
		echo 'Доступ запрещен';
		return;
	}
		
	# получаем опции
	$options = submit_article_get_options();
		
	# подключаем файл вывода меню
	require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/backend-menu.php' ); 
		
	# подключаем файл с определением опций
	require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/settings.php' );
		
	# ключ, тип, ключи массива
	mso_admin_plugin_options2('plugin_'.basename(dirname(__FILE__)), 'plugins', 
		$settings,
		'Настройки плагина «Прислать статью»', # титул
		'От заданных значений опциям будет зависеть доступный посетителям функционал формы. Звёздочкой «<span class="x">*</span>» помечены параметры, часть функционала которых доступна только в <a href="http://vizr.ru/page/plugin-submit-article#buy">платной версии плагина</a>.'   # инфо
	);
		
	# подключаем файл информации об авторе плагина
	require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/author-info.php' );
}


# подключение своих стилей на внешних страницах
function submit_article_head($args = array())
{
	global $MSO;
		
	#  Получаем настройки плагина
	$options = submit_article_get_options();
	if( count($options) == 0 )
	{
		return $args; # если опции не заданы, то выводить нечего - передаём разбор запроса дальше
	}
		
	# подключаем стили виджета на всех страницах
	if( isset($options['widget_mode']) && $options['widget_mode'] ) # подключение виджета при необходимости
	{
		if( file_exists(getinfo('plugins_dir').basename(dirname(__FILE__)).'/custom-widget.css') )
		{
			echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/custom-widget.css" type="text/css" media="screen">'.NR;
		}
		else
		{
			echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/widget.css" type="text/css" media="screen">'.NR;
		}
	}
		
	$options['css_slug'] = explode(',', $options['css_slug']); array_walk($options['css_slug'], 'trim');
		
	if( mso_segment(1) == $options['slug'] || in_array(mso_segment(1), $options['css_slug']) )
	{
		echo '<!-- плагин '.basename(dirname(__FILE__)).' -->'.NR;
		echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/style.css" type="text/css" media="screen">'.NR;
		echo "
			<script type=\"text/javascript\">
				var sess = '".$MSO->data['session']['session_id']."';
			</script>
		";
			
		# Подключение скриптов редакторов
		if( mso_segment(1) == $options['slug'] )
		{
			if( $options['editor'] == '1' ) # markItUp
			{
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/markitup/jquery.markitup.js"></script>'.NR; # подключаем js от редактора markItUp
				echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/markitup/style.css" type="text/css" media="screen">'.NR; #  подключаем стили от редактора markItUp
				echo "<script type=\"text/javascript\">
							var markitup_opt = {
								nameSpace:'bbcode',
								markupSet:[
									{name:'Полужирный', openWith:'[b]', closeWith:'[/b]', className:'bold', key:'B'},
									{name:'Курсив', openWith:'[i]', closeWith:'[/i]', className:'italic', key:'I'},
									{name:'Подчеркнутый', openWith:'[u]', closeWith:'[/u]', className:'underline', key:'U'},
									{name:'Зачеркнутый', openWith:'[s]', closeWith:'[/s]', className:'stroke', key:'S'},
									{name:'Заголовок1', openWith:'[h1]', closeWith:'[/h1]', className:'h1'},
									{name:'Заголовок2', openWith:'[h2]', closeWith:'[/h2]', className:'h2'},
									{name:'Заголовок3', openWith:'[h3]', closeWith:'[/h3]', className:'h3'},
									{name: 'Список', className:'list-bullet', openBlockWith:'[list]\\n', openWith:'[*]', closeWith:'', closeBlockWith:'\\n[/list]', multiline:true, dropMenu: [ 
										{name:'Номера', className:'list-numeric', openBlockWith:'[ol]\\n', openWith:'[*]', closeWith:'', closeBlockWith:'\\n[/ol]', multiline:true}, 
										{name:'Элемент списка', openWith:'[*]', className:'list-item'},
									]},
									{name:'По левому краю', openWith:'[left]', closeWith:'[/left]', className:'left'},
									{name:'По центру', openWith:'[center]', closeWith:'[/center]', className:'center'},
									{name:'По правому краю', openWith:'[right]', closeWith:'[/right]', className:'right'},
									{name:'По ширине', openWith:'[justify]', closeWith:'[/justify]', className:'justify'},
									{name:'Размер текста', openWith:'[size=]', closeWith:'[/size]', className:'text_smallcaps'},
									{name:'Цвет', openWith:'[color=]', closeWith:'[/color]', className:'colors'},
									{name:'Принудительный перенос', replaceWith:'[br]', className:'br'},
									{name:'Преформатированный текст', openWith:'[pre]', closeWith:'[/pre]', className:'pre'},
									{name:'Цитата', openWith:'[quote]', closeWith:'[/quote]', className:'quote'},
									{name:'Код', openBlockWith:'[code]', closeBlockWith:'[/code]', className:'code'}, 
									{name:'Изображение', openWith:'[img]', closeWith:'[/img]', className:'picture'},
									{name:'Ссылка', openBlockWith:'[url]', closeBlockWith:'[/url]', className:'link'},
									".submit_article_get_smiles()."
									{name:'Youtube-Видео', openBlockWith:'[youtube]', closeBlockWith:'[/youtube]', className:'youtube'},
									{name:'Отметить конец анонса', replaceWith:'[cut]\\n', className:'separator'}, 
									{separator:'---------------'},
									{name:'Помощь по BB-кодам', className:'help', beforeInsert:function(){window.open('".getinfo('plugins_url')."bbcode/bbcode-help.html');} },
									
								],
							}
						</script>".NR;
			 
				echo '<script type="text/javascript" >
						$(document).ready(function() {
							$("#sa_text").markItUp(markitup_opt);
						});
					</script>'.NR;
			}
			if( $options['editor'] == '2' ) # markItUp
			{
				//mso_hook('editor_markitup_bbcode')
					
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/markitup/jquery.markitup.js"></script>'.NR; # подключаем js от редактора markItUp
				echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/markitup/style_ext.css" type="text/css" media="screen">'.NR; #  подключаем стили от редактора markItUp
				echo "<script type=\"text/javascript\">
							var markitup_opt = {
								nameSpace:'bbcode',
								markupSet:[
									{name:'Шрифт', openWith:'[b]', closeWith:'[/b]', className:'fonts', multiline:false, dropMenu: [
										{name:'Полужирный (важный)', openWith:'[b]', closeWith:'[/b]', className:'bold', key:'B' },
										{name:'Курсив (важный)', openWith:'[i]', closeWith:'[/i]', className:'italic', key:'I' },
										{separator:'---------------' },
										{name:'Полужирный (простой)', openWith:'[bold]', closeWith:'[/bold]', className:'bold' },
										{name:'Курсив (простой)', openWith:'[italic]', closeWith:'[/italic]', className:'italic' },
										{separator:'---------------' },
										{name:'Подчеркнутый', openWith:'[u]', closeWith:'[/u]', className:'underline' },
										{name:'Зачеркнутый', openWith:'[s]', closeWith:'[/s]', className:'stroke' },
										{separator:'---------------' },
										{name:'Верхний индекс', openWith:'[sup]', closeWith:'[/sup]', className:'sup' },
										{name:'Нижний индекс', openWith:'[sub]', closeWith:'[/sub]', className:'sub' },
										{separator:'---------------' },
										{name:'Уменьшенный шрифт', openWith:'[small]', closeWith:'[/small]', className:'small' },
										{separator:'---------------' },
										{name:'Размер текста', openWith:'[size=[![Размер текста]!]%]', closeWith:'[/size]', className:'text-smallcaps'},
									]},
									{name:'Ссылка', key:'L', openBlockWith:'[url=[![Адрес с http://]!]]', closeBlockWith:'[/url]', className:'link', dropMenu: [
										{name:'Ссылка (адрес и текст)', openBlockWith:'[url=[![Адрес с http://]!]][![Текст ссылки]!][/url]', closeBlockWith:'', className:'link'}, 
									]},
									{name:'Цитата', openBlockWith:'[quote]\\n', closeBlockWith:'\\n[/quote]', className:'quote', dropMenu: [
										{name:'Цитата (блок)', openBlockWith:'\\n[quote]\\n', closeBlockWith:'\\n[/quote]', className:'quote'},
										{name:'Цитирование в строке', openBlockWith:'[q]', closeBlockWith:'[/q]', className:'quote'},
										{name:'Аббревиатура', openBlockWith:'[abbr [![Определение]!]]', closeBlockWith:'[/abbr]', className:'abbr'},
										{name:'Сноска', openBlockWith:'[cite]', closeBlockWith:'[/cite]', className:'cite'},
										{name:'Адрес', openBlockWith:'[address]', closeBlockWith:'[/address]', className:'address'},
										{name:'Новый термин', openBlockWith:'[dfn]', closeBlockWith:'[/dfn]', className:'dfn'},
										{name:'Код (строка)', openBlockWith:'[code]', closeBlockWith:'[/code]', className:'code1'},
									]},
									{name:'Изображение', openBlockWith:'[img [![Описание]!]][![Адрес]!][/img]', className:'picture', dropMenu: [
										{name:'Изображение', replaceWith:'[img][![Адрес]!][/img]', className:'picture'}, 
										{separator:'---------------' },
										{name:'[img]', openBlockWith:'[img [![Описание]!]][![Адрес]!][/img]', className:'image_add'},
										{name:'[img(left)]', openBlockWith:'[img(left) [![Описание]!]][![Адрес]!][/img]', className:'image_add'},
										{name:'[img(right)]', openBlockWith:'[img(right) [![Описание]!]][![Адрес]!][/img]', className:'image_add'},
										{name:'[img(center)]', openBlockWith:'[img(center) [![Описание]!]][![Адрес]!][/img]', className:'image_add'},
									]},
									{name:'Цвет', openWith:'[color=[![Color]!]]', closeWith:'[/color]', className:'colors', dropMenu: [
										{name:'Желтый', openWith:'[color=yellow]', closeWith:'[/color]', className:'col-yellow' },
										{name:'Оранжевый', openWith:'[color=orange]', closeWith:'[/color]', className:'col-orange' },
										{name:'Красный', openWith:'[color=red]', closeWith:'[/color]', className:'col-red' },
										{name:'Синий', openWith:'[color=blue]', closeWith:'[/color]', className:'col-blue' },
										{name:'Фиолетовый', openWith:'[color=purple]', closeWith:'[/color]', className:'col-purple' },
										{name:'Зеленый', openWith:'[color=green]', closeWith:'[/color]', className:'col-green' },
										{name:'Белый', openWith:'[color=white]', closeWith:'[/color]', className:'col-white' },
										{name:'Серый', openWith:'[color=gray]', closeWith:'[/color]', className:'col-gray' },
										{name:'Черный', openWith:'[color=black]', closeWith:'[/color]', className:'col-black' },
										{name:'Ярко-голубой', openWith:'[color=cyan]', closeWith:'[/color]', className:'col-cyan' },
										{name:'Ярко-зеленый', openWith:'[color=lime]', closeWith:'[/color]', className:'col-lime' },
										{name:'Таблица цветов', className:'help', beforeInsert:function(){miu.select_colors();}, className:'col-select'},
									]},
									".submit_article_get_smiles()."
									{separator:'---------------' },
									{name:'Заголовок', openWith:'[h1]', closeWith:'[/h1]', className:'h1', dropMenu: [
										{name:'Заголовок 1', openWith:'[h1]', closeWith:'[/h1]', className:'h1'}, 
										{name:'Заголовок 2', openWith:'[h2]', closeWith:'[/h2]', className:'h2'}, 
										{name:'Заголовок 3', openWith:'[h3]', closeWith:'[/h3]', className:'h3'}, 
										{name:'Заголовок 4', openWith:'[h4]', closeWith:'[/h4]', className:'h4'}, 
										{name:'Заголовок 5', openWith:'[h5]', closeWith:'[/h5]', className:'h5'}, 
										{name:'Заголовок 6', openWith:'[h6]', closeWith:'[/h6]', className:'h6'}, 
									]},
									{name:'Выравнивание', openWith:'[pleft]', closeWith:'[/pleft]', className:'left', dropMenu :[  
										{name:'Абзац влево', openWith:'[pleft]', closeWith:'[/pleft]', className:'left' },
										{name:'Абзац по центру', openWith:'[pcenter]', closeWith:'[/pcenter]', className:'center' },
										{name:'Абзац вправо', openWith:'[pright]', closeWith:'[/pright]', className:'right' },
										{name:'Абзац по формату', openWith:'[pjustify]', closeWith:'[/pjustify]', className:'justify' },
										{separator:'---------------' },
										{name:'Блок влево', openWith:'[left]', closeWith:'[/left]', className:'text-padding-left'}, 
										{name:'Блок по центру', openWith:'[center]', closeWith:'[/center]', className:'text-padding-center'},       
										{name:'Блок вправо', openWith:'[right]', closeWith:'[/right]', className:'text-padding-right'}, 
										{name:'Блок по формату', openWith:'[justify]', closeWith:'[/justify]', className:'text-padding-justify'}, 
										{separator:'---------------' },
										{name:'p - абзац', openWith:'[p]', closeWith:'[/p]', className:'add'}, 
										{separator:'---------------' },
										{name:'div.class', openBlockWith:'[div([![Css class]!])]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'span.class', openBlockWith:'[span([![Css class]!])]', closeBlockWith:'[/span]', className:'add'}, 
										{name:'&lt;div свойства&gt;', openBlockWith:'[div [![Свойства]!]]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'&lt;span свойства&gt;', openBlockWith:'[span [![Свойства]!]]', closeBlockWith:'[/span]', className:'add'}, 
									]},
									{name:'Сообщения', openWith:'[div(message [![Css message]!])]', closeWith:'[/div]', className:'page-red', dropMenu :[  
										{name:'Note', openBlockWith:'[div(message note)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Alert', openBlockWith:'[div(message alert)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Idea', openBlockWith:'[div(message idea)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Error', openBlockWith:'[div(message error)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Ok', openBlockWith:'[div(message ok)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'About', openBlockWith:'[div(message about)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Mail', openBlockWith:'[div(message mail)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Home', openBlockWith:'[div(message home)]', closeBlockWith:'[/div]', className:'add'}, 
										{name:'Question', openBlockWith:'[div(message question)]', closeBlockWith:'[/div]', className:'add'}, 
									]},
									{name: 'Список', className:'list-bullet', openBlockWith:'[list]\\n', openWith:'[*]', closeWith:'', closeBlockWith:'\\n[/list]', multiline:true, dropMenu: [ 
										{name:'Номера', className:'list-numeric', openBlockWith:'[ol]\\n', openWith:'[*]', closeWith:'', closeBlockWith:'\\n[/ol]', multiline:true}, 
										{name:'Элемент списка', openWith:'[*]', className:'list-item'},
										{separator:'---------------' },
										{name:'Список определений', openBlockWith:'\\n[dl]\\n', closeBlockWith:'\\n[/dl]', className:'dl'}, 
										{name:'Определение', openBlockWith:'[dt]', closeBlockWith:'[/dt]', className:'dl'}, 
										{name:'Описание', openBlockWith:'[dd]', closeBlockWith:'[/dd]', className:'dl'}, 
										{name:'Заготовка', openBlockWith:'\\n[dl]\\n[dt]Определение[/dt]\\n[dd]Описание[/dd]\\n\\n[dt]Определение[/dt]\\n[dd]Описание[/dd]\\n[/dl]', closeBlockWith:'', className:'dl'}, 
									]},
									{name:'Таблица', openBlockWith:'\\n[table]\\n', closeBlockWith:'\\n[/table]', className:'table', dropMenu: [
										{name:'Таблица', openBlockWith:'\\n[table]\\n', closeBlockWith:'\\n[/table]\\n', className:'table-add'}, 
										{name:'Строка', openBlockWith:'[tr]\\n', closeBlockWith:'\\n[/tr]',  className:'table-row-insert'}, 
										{name:'Строка ячеек', openBlockWith:'[tr]\\n', closeBlockWith:'\\n[/tr]', openWith:'[td]', closeWith:'[/td]', className:'table-row-insert'},
										{name:'Ячейки', openWith:'[td]', closeWith:'[/td]', className:'table-select'}, 
										{name:'Заготовка1', openBlockWith:'[table]\\n[tr]\\n[td] [/td]\\n[td] [/td]\\n[td] [/td]\\n[/tr]\\n[/table]', className:'table-go'}, 
										{name:'Заготовка2', openBlockWith:'\\n[tr]\\n[td] [/td]\\n[td] [/td]\\n[td] [/td]\\n[/tr]', className:'table-go'}, 
									]},
									{separator:'---------------'},
									{name:'Подсветка синтаксиса', openBlockWith:'[pre]', closeBlockWith:'[/pre]', className:'code', dropMenu: [
										{name:'Обычный текст', openBlockWith:'[pre]', closeBlockWith:'[/pre]', className:'text' },
										{name:'PHP-код', openBlockWith:'[pre lang=php]', closeBlockWith:'[/pre]', className:'php' },
										{name:'HTML-код', openBlockWith:'[pre lang=html]', closeBlockWith:'[/pre]', className:'html-pre' },
										{name:'CSS-код', openBlockWith:'[pre lang=css]', closeBlockWith:'[/pre]', className:'css' },
										{name:'JavaScript-код', openBlockWith:'[pre lang=js]', closeBlockWith:'[/pre]', className:'js' },
										{name:'Delphi/Pascal-код', openBlockWith:'[pre lang=delphi]', closeBlockWith:'[/pre]', className:'delphi' },
										{name:'SQL-код', openBlockWith:'[pre lang=sql]', closeBlockWith:'[/pre]', className:'sql' },
										{name:'C#-код', openBlockWith:'[pre lang=csharp]', closeBlockWith:'[/pre]', className:'csharp' },
										{name:'XML-код', openBlockWith:'[pre lang=xml]', closeBlockWith:'[/pre]', className:'xml' }
									]},
									{name:'Очистить текст от BB-кодов', className:'clean', replaceWith:function(h) { return h.selection.replace(/\[(.*?)\]/g, '') }, className:'clean', dropMenu: [
										{name:'Очистить текст от BB-кодов', className:'clean', replaceWith:function(h) { return h.selection.replace(/\[(.*?)\]/g, '') }, className:'clean'},
										{name:'Очистить текст от HTML', className:'clean', replaceWith:function(h) { return h.selection.replace(/\<(.*?)\>/g, '') }, className:'clean'},
										{name:'Замена в тексте', className:'qrepl', beforeInsert:function(markItUp) { miu.repl(markItUp) }},
										{separator:'---------------' },
										{name:'Принудительный перенос', replaceWith:'[br]\\n', className:'page-red'},
										{name:'Линия', openBlockWith:'\\n[hr]\\n', className:'hr'}, 
										{separator:'---------------' },
										{name:'Показать/спрятать (show)', openBlockWith:'[show [![Заголовок блока]!]]', closeBlockWith:'[/show]', className:'add'}, 
										{separator:'---------------' },
										{name:'Счетчик переходов', openBlockWith:'[dc]', closeBlockWith:'[/dc]', className:'add'}, 
										{separator:'---------------' },
										{name:'Показать/спрятать (spoiler)', openBlockWith:'[spoiler=[![Заголовок блока]!]]', closeBlockWith:'[/spoiler]', className:'add'}, 
										{separator:'---------------' },
										{name:'Спрятать от незалогиненных', openBlockWith:'[auth]', closeBlockWith:'[/auth]', className:'add'}, 
									]},
									{separator:'---------------' },
									{name:'Отметить конец анонса', replaceWith:'\\n[cut]\\n', className:'separator', dropMenu: [
										{name:'Отрезать анонс', replaceWith:'\\n[xcut]\\n', className:'separator2'},
									]},
									{separator:'---------------' },
									{name:'Помощь по BB-кодам', className:'help', beforeInsert:function(){window.open('".getinfo('plugins_url')."bbcode/bbcode-help.html');} },".NR;

									mso_hook('editor_markitup_bbcode');
				echo "
								],
							}
							miu = {
								repl: function(markItUp) 
								{
									str = markItUp.textarea.value;
									
									var s_search = prompt('Что ищем?');
									var s_replace = prompt('На что меняем?');
									
									markItUp.textarea.value = str.replace(new RegExp(s_search,'g'), s_replace)
									
									alert('Выполнено!');
								},	
								
								select_colors: function()
								{
									window.open('".getinfo('plugins_url').basename(dirname(__FILE__))."/markitup/color-table.html');
								},
							}
						</script>".NR;
			 
				echo '<script type="text/javascript" >
						$(document).ready(function() {
							$("#sa_text").markItUp(markitup_opt);
						});
					</script>'.NR;
			}
			if( $options['editor'] == '3' ) # editor_jw
			{
				echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/editor_jw/jquery.wysiwyg.css" type="text/css" media="screen">'.NR; #  подключаем стили от редактора editor_jw
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/editor_jw/jquery.wysiwyg.js"></script>'.NR; # подключаем js от редактора editor_jw
				echo '<script type="text/javascript" >
						$(document).ready(function() {
							$("#sa_text").wysiwyg({
								autoSave		: true,
									
								css				: "'.getinfo('plugins_url').basename(dirname(__FILE__)).'/editor_jw/styles.css",
								controls		: {},
								controls_extra	: 
								{
									separator1 : { separator : true }
								}
							});
						});
					</script>'.NR;
			}
			if( $options['editor'] == '4' ) # buttons_ed
			{
				echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/buttons_ed/style.css" type="text/css" media="screen">'.NR; #  подключаем стили
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/buttons_ed/main.js"></script>'.NR; # подключаем js
			}
			# Подключение счётчика символов
			if( $options['max_text_chars_counter'] == 1 && $options['max_text_chars'] > 0 ) # счётчик символов
			{
				echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/char_counter/style.css" type="text/css" media="screen">'.NR; #  подключаем стили
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/char_counter/main.js"></script>'.NR; # подключаем js
				echo '<script type="text/javascript" >
						$(document).ready(function() {
							$("#sa_text").charCount({
								allowed: '.$options['max_text_chars'].',		
								warning: 20,
								counterText: "Осталось символов: ",
								counterElement: "div"
							});
						});
					</script>'.NR;
			}
				
			# Подключение загрузчика иллюстраций только на странице с формой
			if( $options['can_upload'] == 1 ) # можно
			{
				# подключение скриптов для аплоада
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/upload/jquery.ui.widget.js"></script>'.NR; # подключаем js
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/upload/jquery.iframe-transport.js"></script>'.NR; # подключаем js
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/upload/jquery.fileupload.js"></script>'.NR; # подключаем основной js
					
				# Куда отправлять служебные AJAX-запросы
				$ajax_path = getinfo('ajax').base64_encode('plugins/'.basename(dirname(__FILE__)).'/upload-ajax.php');
				$check_limit = isset($options['upload_allowed_size']) && $options['upload_allowed_size'] > 0 ? true : false;
				
				echo "
					<script type=\"text/javascript\">
						var upload_path = '".$ajax_path."',
							check_limit = '".$check_limit."',
							tmpfolder = '".$options['temp_folder']."',
							save_attach = '".$options['save_notinserted_uploads']."',
							show_ins = '".$options['can_insert_upload']."',
							preview_width = '".$options['upload_preview_width']."';
					</script>
				";
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/js/upload.js"></script>'.NR; # подключаем js со служебными функциями
			}
				
			# Подключение кнопки предпросмотра
			if( $options['show_preview_button'] == 1 )
			{
				# Куда отправлять служебные AJAX-запросы
				$preview_ajax_path = getinfo('ajax').base64_encode('plugins/'.basename(dirname(__FILE__)).'/preview-ajax.php');
					
				echo "
					<script type=\"text/javascript\">
						var preview_path = '".$preview_ajax_path."';
					</script>
				";
				echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/js/preview.js"></script>'.NR;
			}
		}
			
		# стили пользователя
		if( file_exists(getinfo('plugins_dir').basename(dirname(__FILE__)).'/custom.css') )
		{
			echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/custom.css" type="text/css" media="screen">'.NR;
		}
		if( $options['css'] <> '' )
		{
			# Опциональные стили	
			echo '<style>'.NR.$options['css'].NR.'</style>'.NR;
		}
			
		echo '<!-- плагин '.basename(dirname(__FILE__)).' -->'.NR;
	}
		
	if( mso_segment(1) == 'users' && mso_segment(3) == 'edit' )
	{
		echo '<!-- плагин '.basename(dirname(__FILE__)).' -->'.NR;
		echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/style.css" type="text/css" media="screen">'.NR;
			
		# стили пользователя
		if( file_exists(getinfo('plugins_url').basename(dirname(__FILE__)).'/custom.css') )
		{
			echo '<link rel="stylesheet" href="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/custom.css" type="text/css" media="screen">'.NR;
		}
		if( $options['css'] <> '' )
		{
			# Опциональные стили	
			echo '<style>'.NR.$options['css'].NR.'</style>'.NR;
		}
			
		if( $options['comuser_can_unsubscribe'] == 1 ) # можно отписаться от комментариев к присланному комюзером материалу
		{
			$ssval = 0;
			$comid = mso_clean_str(mso_segment(2), 'int');

			$CI = & get_instance();
			$CI->db->select('meta_value');
			$CI->db->where('meta_id_obj', $comid);
			$CI->db->where('meta_table', 'comusers');
			$CI->db->where('meta_key', 'subscribe_submited');
			$qry = $CI->db->get('meta');
				
			if( $qry && $row = $qry->row_array(1) && isset($row['meta_value']) ) # 
			{
				$ssval = $row['meta_value'];
			}
				
			echo "
				<script type=\"text/javascript\">
					var subscribe_submited = ".$ssval.";
				</script>
			";
				
			echo '<script src="'.getinfo('plugins_url').basename(dirname(__FILE__)).'/js/notify.js"></script>'.NR; # подключаем для создания чекбокса подписки/отписки
			
		}
			
		echo '<!-- плагин '.basename(dirname(__FILE__)).' -->'.NR;
	}
		
	return $args;
}

# обрабатываем запросы к внешней части сайта
function submit_article_custom_page_404($args = false)
{
	global $MSO;
	$CI = & get_instance();
	$out = '';
		
	# след.код нужен для борьбы с багом в common.php строки 2108
	if( !isset($MSO->data['session']['users_id']) ) // и в сесии
		$user_id = false;
	else
		$user_id = $MSO->data['session']['users_id']; // берем его номер из сессии
	
	#  Получаем настройки плагина
	$options = submit_article_get_options();
	if( count($options) == 0 ) # если опции не заданы, то админу выводим  сообщение о ненастроенности, а остальным - 404
	{
		if( $user_id && mso_check_allow(basename(dirname(__FILE__)).'_options') )
		{
			$out = '<div class="'.basename(dirname(__FILE__)).'_form">'.NR.'<div class="message error small">Плагин «SUBMIT ARTICLE» не настроен! Пройдите на страницу <a href="/admin/plugin_options/'.basename(dirname(__FILE__)).'">опций</a> для задания нужных значений параметров.</div>'.NR.'</div>'.NR;
		}
		else
			return $args;
	} 
		
	if( $out == '' )
	{
		if( $options['redirect_submit_article_uri'] && $options['slug'] != basename(dirname(__FILE__)) && mso_segment(1) == basename(dirname(__FILE__)) )
		{
			mso_redirect($options['slug'], false, 301);
			die();
		}
		
		if( $options['stealth_mode'] == 'on404' && (!$user_id || !mso_check_allow(basename(dirname(__FILE__)).'_options')) )
		{
			return $args;
		}
			
		if( $options['stealth_mode'] == 'onMM' && (!$user_id || !mso_check_allow(basename(dirname(__FILE__)).'_options')) )
		{
			if( mso_segment(1) == $options['slug'] )
			{
				$out = '<div class="'.basename(dirname(__FILE__)).'_form">'.NR.'<div class="message alert small">'.$options['stealth_mode_MM_msg'].'</div>'.NR.'</div>'.NR;
			}
			else
			{
				return $args;
			}
		}
		else
		{
			$admin = isset($MSO->data['session']['users_groups_id']) && $MSO->data['session']['users_groups_id'] == 1 ? true : false;
				
			# роутинг запросов
			if( mso_segment(1) == $options['slug'] && !$_POST && mso_segment(2) == '' ) # просто выводим форму
			{
				require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/frontend-form.php' ); # подключили файл для вывода внешней части сайта
			}
				
			if( mso_segment(1) == $options['slug'] && !$_POST && mso_segment(2) <> '' && mso_segment(3) == '' && ( $options['comuser_can_edit_published'] == 1 || $options['comuser_can_edit_draft'] == 1 || $admin ) )
			{
				$pid = mso_clean_str(mso_segment(2), 'int');
					
				# Читаем из базы информацию о статье
				$CI->db->select('*');
				$CI->db->from('page');
				$CI->db->where('page_id', $pid);
					
				$qry = $CI->db->get();
				if( $qry->num_rows() > 0 )	
				{	
					$res = $qry->result_array();
					$pg = $res[0];
						
					# загружаем мета-информацию
					$CI->db->select('meta_key, meta_value');
					$CI->db->from('meta');
					$CI->db->where('meta_id_obj', $pid);
					$CI->db->where('meta_table', 'page');
						
					$qry = $CI->db->get();
					if( $qry->num_rows() > 0 )	
					{	
						$meta = $qry->result_array();
						foreach( $meta as $val )
						{
							$pg['meta'][$val['meta_key']] = $val['meta_value'];
						}
					}
						
					# загружаем рубрики
					$pg['category'] = array();
					$CI->db->select('category_id');
					$CI->db->from('cat2obj');
					$CI->db->where('page_id', $pid);
						
					$qry = $CI->db->get();
					if( $qry->num_rows() > 0 )	
					{	
						$cat = $qry->result_array();
						foreach( $cat as $val )
						{
							$pg['category'][] = $val['category_id'];
						}
					}
						
					# определяем редактируемость материала
					$edable = false;
					if( isset($pg['meta']['editable']) && ( ( $options['comuser_can_edit_published'] && $pg['page_status'] == 'publish' ) || ( $options['comuser_can_edit_draft'] && $pg['page_status'] == 'draft') ) )
					{
						$edable = true;
					}
						
					if( (isset($pg['meta']['comusers_id']) && is_login_comuser() && getinfo('comusers_id') == $pg['meta']['comusers_id'] && $edable) || $admin ) # если залогинен комюзер-автор, то можно дальше обрабатывать
					{
						$edit = true; # Задаём режим редактирования материала
							
						require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/frontend-form.php' ); # подключили файл для вывода внешней части сайта
					}
				}
			}
				
			if( mso_segment(1) == $options['slug'] && $_POST ) # обработка сохранения формы
			{
				if( mso_segment(2) <> '' )
				{
					$pid = mso_clean_str(mso_segment(2), 'int');
				}
				else
				{
					if( isset($_POST['page_id']) )
					{
						$pid = mso_clean_str($_POST['page_id'], 'int');
					}
				}
					
				require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/frontend-form-submit.php' ); # подключили файл для вывода внешней части сайта
			}
				
			if( mso_segment(1) == $options['slug'] && !$_POST && mso_segment(2) == 'clean' ) # чистка мусора - удаление неиспользованных загруженных файлов по крону
			{
				require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/clean.php' ); # подключили файл для чистки мусора
				echo "cleaning complete!";
				exit;
			}
				
			# вывод на profile-странице комюзера
			if( in_array('profile', $MSO->active_plugins) )
			{
				$opt_profile = mso_get_option('profile', 'plugins', array());
				if( count($opt_profile) > 0 ) # если опции не заданы, то пропускаем
				{
					if( mso_segment(1) == $opt_profile['profile_slug'] && mso_segment(2) == $options['slug'] && mso_segment(3) == '' ) # маршрутизация запроса
					{
						require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/profile.php' ); # подключили файл для чистки мусора
						exit;
					}
				}
			}
		}
	}
		
	# вывод результата обработки запроса
	if( $out )
	{
		# задаём значения по-умолчанию, если не заданы обязательные
		if( !isset($options['title']) ) $options['title'] = '';
		if( !isset($options['head_title']) ) $options['head_title'] = '';
		if( !isset($options['head_description']) ) $options['head_description'] = '';
		if( !isset($options['head_keywords']) ) $options['head_keywords'] = '';
			
		@header('HTTP/1.1 200 OK'); # перебиваем заголовок, иначе range_url выдаст 404
			
		$head_title = preg_replace('/\[header\]/i', $options['title'], $options['head_title']);
		$head_title = preg_replace('/\[sitename\]/i', getinfo('title'), $head_title);
			
		mso_head_meta('title', $head_title); # meta title страницы
		mso_head_meta('description', $options['head_description']); # meta description страницы
		mso_head_meta('keywords', $options['head_keywords']); # meta keywords страницы
			
		# начальная часть шаблона
		if( file_exists(getinfo('template_dir').'main-start.php') ) 
		{
			require(getinfo('template_dir').'main-start.php');
		}
		else
		{
			require(getinfo('shared_dir').'main/main-start.php');
		}
				
			echo NR.'<div class="type type_'.basename(dirname(__FILE__)).'"><div class="page_only"><div class="wrap">'.NR;
			echo $out;
			echo NR.'</div></div><!-- class="page_only" --></div><!-- class="type type_'.basename(dirname(__FILE__)).'" -->'.NR;
				
		# конечная часть шаблона
		if( file_exists(getinfo('template_dir').'main-end.php') ) 
		{
			require(getinfo('template_dir').'main-end.php');
		}
		else
		{
			require(getinfo('shared_dir').'main/main-end.php');
		}
		return true; # выходим с true, т.к. обработали запрос
	} 
	else 
	{
		return $args; # если выводить нечего - передаём разбор запроса дальше
	}
}

# вывод списка присланного в профайле комюзера
function submit_article_users_add_out($args = array())
{
	#  Получаем настройки плагина
	$options = submit_article_get_options();
	if( count($options) == 0 )
	{
		return $args; # если опции не заданы, то выводить нечего - передаём разбор запроса дальше
	}
		
	if( $options['comuser_work_list'] == 1 ) # выводить ли список публикаций комюзера?
	{
		$comuser_work_list = get_comuser_work_list($args['comusers_id'], $options);
			
		if( $comuser_work_list <> '' )
		{
			echo '<div class="submited"><div class="caption">'.$options['comuser_page_title'].'</div>'.NR;
			echo $comuser_work_list;
			echo '</div>';
		}	
	}
		
	return $args; # передаём разбор запроса дальше
}

# получение списка публикаций
function get_comuser_work_list($comuser_id = 0, $options = array() )
{
	if( count($options) == 0 ) return '';
		
	global $MSO;
	$CI = & get_instance();
	$out = '';
		
	$CI->db->select('mp.page_id, mp.page_title, mp.page_slug, mp.page_status, mm2.meta_value editable');
	$CI->db->from('mso_page mp');
	$CI->db->join('mso_meta mm1', 'mm1.meta_id_obj = mp.page_id', 'left'); 
	$CI->db->join('mso_meta mm2', 'mm2.meta_id_obj = mp.page_id AND mm2.meta_key = "editable"', 'left'); 
	$CI->db->where('mm1.meta_value', $comuser_id);
	$CI->db->where('mm1.meta_key', 'comusers_id');
	$CI->db->where('mm1.meta_table', 'page');
	$CI->db->order_by('mp.page_last_modified', 'asc');
		
	$qry = $CI->db->get();
		
	if( $qry->num_rows() > 0 )	
	{	
		$res = $qry->result_array();
			
		$admin = isset($MSO->data['session']['users_groups_id']) && $MSO->data['session']['users_groups_id'] == 1 ? true : false;
			
		$out .= '<ul>'.NR;
		foreach( $res as $val )
		{
			$out .= '<li>';
				
			if( $val['page_status'] == 'publish' )
			{
				$out .= '<a href="/page/'.$val['page_slug'].'">'.$val['page_title'].'</a>';
					
				if( $admin || ( getinfo('comusers_id') == $comuser_id && $options['comuser_can_edit_published'] == 1 && isset($val['editable']) ) )
				{
					$out .= ' ['.'<a href="/'.$options['slug'].'/'.$val['page_id'].'">редактировать</a>'.']';
				}
			}
			else
			{
				if( $admin )
				{
					$out .= '<a href="/page/'.$val['page_slug'].'">'.$val['page_title'].' (черновик)</a>';
				}
				else
				{
					$out .= $val['page_title'].' (черновик)';
				}
					
				if( $admin || ( getinfo('comusers_id') == $comuser_id && $options['comuser_can_edit_draft'] == 1 && isset($val['editable']) ) )
				{
					$out .= ' ['.'<a href="/'.$options['slug'].'/'.$val['page_id'].'">редактировать</a>'.']';
				}
			}
			$out .= '</li>'.NR;
		}
		$out .= '</ul>'.NR;
	}
		
	return $out;
}

# функция рассылки авторам уведомлений о новых комментариях к их статьям
function submit_article_notify_new_comment($args = array())
{
	#  Получаем настройки плагина
	$options = submit_article_get_options();
	if( count($options) == 0 )
	{
		return $args; # если опции не заданы, то плагин ещё не настроен на работу и скорее всего уведомлять не о чем - передаём разбор запроса дальше
	}
		
	$CI = & get_instance();
	$notify_text = '';
		
	if( !function_exists('mso_get_meta') )
	{
		require_once( getinfo('common_dir').'meta.php' ); 
		$sa_page = mso_get_meta('submit_article', 'page', $args['comments_page_id']);
	}
		
	if( isset($sa_page[0]) ) # уведомления о комментариях рассылаем только к статьям, присланным через плагин
	{
		$CI->db->select('meta_value, meta_id');
		$CI->db->where('meta_id_obj', $args['comments_page_id']);
		$CI->db->where('meta_table', 'page');
		$CI->db->where('meta_key', 'comusers_id');
		$qry = $CI->db->get('meta');
		
		if( $qry && $row = $qry->row_array(1) && isset($row['meta_value']) ) # Проверяем наличие комюзера, которого надо уведомить о новом комментарии
		{
			$comusers_id = $row['meta_value']; # есть комюзер
				
			# проверяем надо ли уведомлять или автор статьи отписался от уведомлений о комментариях к его статьям?
			$sscheck = mso_get_meta('subscribe_submited', 'comusers', $comusers_id);
			if( isset($sscheck[0]['meta_value']) && $sscheck[0]['meta_value'] == 0 )
			{
				# не посылаем уведомление т.к. есть явное желание не получать уведомления
				return $args; 
			}
				
			# проверяем надо ли уведомлять или автор статьи сам комментирует свой материал?
			if( isset($args['comments_comusers_id']) && $comusers_id == $args['comments_comusers_id'] )
			{
				# не посылаем уведомление на свой комментарий к своей статье
				return $args; 
			}
				
			# получаем емайл комюзера, которого надо уведомить
			$CI->db->select('comusers_email, comusers_nik');
			$CI->db->where('comusers_id', $comusers_id);
			$qry = $CI->db->get('comusers');
				
			if( $qry && $qry->num_rows() ) # есть такой комюзер
			{
				$row = $qry->row_array(1);
				$comusers_email = $row['comusers_email'];
				$comusers_nik = $row['comusers_nik'];
			}
			else
			{
				# комюзера почему-то нет в базе. Надо уведомить админа сайта
				if( !isset($options['off_alerts_comuser_notfound']) || $options['off_alerts_comuser_notfound'] == 0 )
				{
					$toadmin = mso_get_option('admin_email', 'general', false);
					if( mso_valid_email($toadmin) )
					{
						# формируем текст уведомления администратора об ошибке в базе данных
						$notify_text  = 'К статье «'.$args['page_title'].'» ( '.mso_get_permalink_page($args['comments_page_id']).' ) оставлен комментарий.'. NR;
						$notify_text  .= 'При попытке определить email для отправки уведомления о новом комментарии комюзер-автор статьи не обнаруживается в базе по id ( '.getinfo('siteurl').'admin/comusers/edit/'.$comusers_id.' )' .NR;
							
						mso_mail($toadmin, 'Ошибка таблицы comusers! [SUBMIT_ARTICLE]', $notify_text);
					}
				}
					
				if( isset($options['reauthor_comuser_notfound']) && $options['reauthor_comuser_notfound'] == 1 )
				{
					$CI->db->where('meta_id', $row['meta_id']);
					$qry = $CI->db->update('meta', array(
						'meta_key' => 'anonymous',
						'meta_value' => 'Комментатор '.$comusers_id
					));
				}
					
				# раз комюзер сбойный, то уведомлять пока некого
				return $args;
			}
				
			# определяем имя комментатора
			$commenter = '';
			if( isset($args['comments_comusers_id']) )
			{
				$CI->db->select('comusers_nik');
				$CI->db->where('comusers_id', $args['comments_comusers_id']);
				$qry = $CI->db->get('comusers');
				
				if( $qry && $qry->num_rows() ) # есть такой комюзер
				{
					$row = $qry->row_array(1);
					$comusers_nik = $row['comusers_nik'];
					$commenter .= $comusers_nik.' ( '.getinfo('siteurl').'users/'.$args['comments_comusers_id'].' )';
				}
				else
				{
					# комюзера почему-то нет в базе. Надо уведомить админа сайта
					$toadmin = mso_get_option('admin_email', 'general', false);
					if( mso_valid_email($toadmin) )
					{
						# формируем текст уведомления администратора об ошибке в базе данных
						$notify_text  = 'К статье «'.$args['page_title'].'» ( '.mso_get_permalink_page($args['comments_page_id']).' ) оставлен комментарий комюзером, который не обнаруживается в базе по id ( '.getinfo('siteurl').'admin/comusers/edit/'.$args['comments_comusers_id'].' )' .NR;
							
						mso_mail($toadmin, 'Ошибка таблицы comusers! [SUBMIT_ARTICLE]', $notify_text);
					}
						
					# раз комюзер сбойный, то уведомлять о его комментарии пока ненужно
					return $args;
				}
			}
			elseif( isset($args['comments_author_name']) && $args['comments_author_name'] )
			{
				$commenter .= $args['comments_author_name'];
			}
		
			# формируем текст уведомления автора о новом комментарии
			$notify_text .= 'Новый комментарий к вашей статье «'.$args['page_title'].'»'.NR.NR;
			$notify_text .= 'Комментатор: '.$commenter.NR ;
			$notify_text .= 'Текст:'.NR.str_repeat("-", 30).NR.mso_xss_clean($args['comments_content']).NR.str_repeat("-", 30).NR;
			$notify_text .= 'Перейти к комментарию на сайте: '.mso_get_permalink_page($args['comments_page_id']).'#comment-'.$args['id'].NR;
		}
		else
		{
			# эту статью не присылал комюзер. Нам делать ничего не нужно.
			return $args;
		}
			
		mso_mail($comusers_email, 'Новый комментарий к вашему материалу! [SUBMIT_ARTICLE]', $notify_text);
	}
		
	return $args;
}

# функция вывода авторского блока
function submit_article_author_box($args = array())
{
	global $page;
		
	#  Получаем настройки плагина
	$options = submit_article_get_options();
	if( count($options) == 0 || !is_type('page') ) # если опции не заданы, то плагин ещё не настроен на работу - передаём разбор запроса дальше
	{
		return;
	}
		
	if( $options['author_info_block_code'] <> '' && 
		isset($page['page_meta']['submit_article'][0]) && $page['page_meta']['submit_article'][0] == 1 && 
		($options['show_block_in_godmode'] || !isset($page['page_meta']['godmode'])) 
	) # не выводим если пост пришёл не через плагин и если постил юзер
	{
		# используем кэширование
		$cache_time = (int) mso_get_option('home_cache_time', 'templates', 100);
		$cache_key = basename(dirname(__FILE__)) . '-authorbox-' . $page['page_slug']. '-' . mso_current_paged();

		if( $cache_time > 0 and $k = mso_get_cache($cache_key) )
		{
			echo $k;
		}
		else
		{
			if( $options['author_info_block_type'] == 1) # PHP
			{
				ob_start();
				eval( stripslashes( $options['author_info_block_code'] ) );
				$out = ob_get_contents();
				ob_end_clean();
			}
			else
			{
				$out = mso_hook('content', $options['author_info_block_code']);
					
				if( isset($page['page_meta']['comusers_id']) )
				{
					$CI = & get_instance();
						
					$CI->db->select('*');
					$CI->db->from('comusers');
					$CI->db->where('comusers_id', $page['page_meta']['comusers_id'][0]);
					$CI->db->limit(1);
					$qry = $CI->db->get();
					if ($qry->num_rows() > 0)
					{
						$author = $qry->result_array(); // данные комюзера
						$page['author'] = $author[0];
					}
					else
					{
						if( $options['show_user_author_info'] )
						{
							$CI->db->select('users_email, users_url');
							$CI->db->limit(1); # одно значение
							$CI->db->where('users_id', $page['page_id_autor']); // where 'users_id' = page_id_autor

							$qry = $CI->db->get('users');

							if( $qry->num_rows() > 0 ) # есть такой юзер
							{
								$author = $qry->result_array();
									
								$page['author']['name'] = $page['users_nik'];
								$page['author']['users_id'] = $page['page_id_autor'];
								$page['author']['comusers_email'] = $author[0]['users_email'];
								$page['author']['comusers_url'] = $author[0]['users_url'];
								$page['author']['comusers_description'] = $page['users_description'];
								$page['author']['comusers_avatar_url'] = $page['users_avatar_url'];
							}
						}
					}
				}
				if( isset($page['page_meta']['anonymous']) )
				{
					$page['author']['name'] = $page['page_meta']['anonymous'][0];
				}
					
				if( !isset($page['author']['name']) && !isset($page['author']['comusers_nik']) )
				{
					if( isset($page['page_meta']['anonymous']) )
					{
						$page['author']['name'] = $page['page_meta']['anonymous'][0];
					}
					else
					{
						if( $options['show_user_author_info'] )
						{
							$CI->db->select('users_email, users_url');
							$CI->db->limit(1); # одно значение
							$CI->db->where('users_id', $page['page_id_autor']); // where 'users_id' = page_id_autor

							$qry = $CI->db->get('users');

							if( $qry->num_rows() > 0 ) # есть такой юзер
							{
								$author = $qry->result_array();
									
								$page['author']['name'] = $page['users_nik'];
								$page['author']['users_id'] = $page['page_id_autor'];
								$page['author']['comusers_email'] = $author[0]['users_email'];
								$page['author']['comusers_url'] = $author[0]['users_url'];
								$page['author']['comusers_description'] = $page['users_description'];
								$page['author']['comusers_avatar_url'] = $page['users_avatar_url'];
							}
						}
						else
						{
							$page['author']['name'] = 'NoName'; # совсем уж крайний случай - нет имени
						}
					}
				}
					
				if( $out )
				{
					while( preg_match('/\[(\+|\-)(NAME|SITE|EMAIL|ABOUT|PROFILE|AVATAR|GRAVATAR)\]([^\\1\\2]*?)\[\/\\1\\2\]/mis', $out) )
					{
						$out = preg_replace_callback('/\[(\+|\-)(NAME|SITE|EMAIL|ABOUT|PROFILE|AVATAR|GRAVATAR)\]([^\\1\\2]*?)\[\/\\1\\2\]/mis', 'replace_ifmacros_callback', $out);
					}
					
					$out = preg_replace_callback('/\[(NAME|SITE|EMAIL|ABOUT|PROFILE|AVATAR|GRAVATAR(\=(\d*?)){0,1})\]/mis', 'replace_macros_callback', $out);
				}
			}
				
			if( $out )
			{
				echo $out;
				mso_add_cache($cache_key, $out, $cache_time * 60); # сохраняем в кэш
			}
		}
	}
		
	return $args;
}

function get_macros_value($tag = '')
{
	global $page;
	if( $tag == '' ) return '';
	$tag = explode('=', $tag);
	$out = '';
		
	# выносим код в отдельный файл для реализации Pro/Lite версии
	require(getinfo('plugins_dir').basename(dirname(__FILE__)).'/author-box-codes.php');
		
	return $out;
}

function replace_macros_callback($matches)
{
	return get_macros_value($matches[1]);
}

function replace_ifmacros_callback($matches)
{
	$tag_value = get_macros_value($matches[2]);
	if( $matches[1] == '+' && $tag_value <> '' )
	{
		return $matches[3];
	}
	elseif( $matches[1] == '-' && $tag_value == '' )
	{
		return $matches[3];
	}
	else
	{
		return '';
	}
}

# функции плагина
function submit_article_get_smiles()
{
	// смайлы - код из comment_smiles
	$image_url = getinfo('uploads_url').'smiles/';
	$CI = & get_instance();
	$CI->load->helper('smiley_helper');
	$smileys = _get_smiley_array();
	$used = array();
	$smiles = '';
	
	foreach( $smileys as $key => $val )
	{
		# Для того, чтобы для смайлов с одинаковыми картинками (например :-) и :))
		# показывалась только одна кнопка
		if( isset($used[$smileys[$key][0]]) )
		{
		  continue;
		}
		
		$im = "<img src='".$image_url.$smileys[$key][0]."' title='".$key."'>";
		$smiles .= '{name:"'. addcslashes($im, '"').'", notitle: "1", replaceWith:"'.$key.'", className:"col1-0" },'.NR;
		
		$used[$smileys[$key][0]] = TRUE;
	}
	if( $smiles )
	{
		$smiles = NR."{name:'".t('Смайлы')."', openWith:':-)', closeWith:'', className:'smiles', dropMenu: [" 
				. $smiles
				. ']},';
		return $smiles;
	}
}

function submit_article_get_types()
{
	$CI = & get_instance();
	$out = '0||Тип записи не определен';
		
	# нужно выбрать все типы публикаций
	$CI->db->from('page_type');
	$CI->db->order_by('page_type_id', 'ASC');
	if( $qry = $CI->db->get() )
	{ 
		$types = $qry->result_array();
		foreach( $types as $t )
		{
			$out .= '# '.$t['page_type_id'].'||'.$t['page_type_name'].' ('.$t['page_type_desc'].')';
		}
	}
		
	return $out;
}

function submit_article_get_users()
{
	$CI = & get_instance();
	$out = '0||Юзер не определен';
		
	# нужно выбрать все типы публикаций
	$CI->db->select('users_id, users_login, users_nik');
	$CI->db->from('users');
	$CI->db->order_by('users_id', 'ASC');
	if( $qry = $CI->db->get() )
	{ 
		$users = $qry->result_array();
		foreach( $users as $u )
		{
			if( $u['users_nik'] <> '' )
			{
				$out .= '# '.$u['users_id'].'||'.$u['users_nik'].' ';
			}
			else
			{
				$out .= '# '.$u['users_id'].'||'.$u['users_login'].' ';
			}
		}
	}
		
	return $out;
}

# Формирование списка рубрик для поля выбора рубрики
function submit_article_get_categories()
{
	$CI = & get_instance();
	$res = array();
		
	# нужно выбрать все рубрики первого уровня
	$CI->db->from('category');
	$CI->db->where('category_id_parent', 0);
	$CI->db->where('category_type', 'page');
	$CI->db->order_by('category_menu_order', 'ASC');
	if($qry = $CI->db->get())
	{ 
		$cats = $qry->result_array();
		foreach( $cats as $c )
		{
			$res[] = $c['category_id'].'||'.$c['category_name'].' ('.$c['category_slug'].')';
		}
	}
		
	return implode('#', $res);
}

# получение опций со значениями по-умолчанию
function submit_article_get_options( $optskey = '', $optsfile = 'settings.php', $refresh = false )
{
	static $options;
		
	if( !isset($optskey) || $optskey == '' ) $optskey = 'plugin_'.basename(dirname(__FILE__));
		
	if( !isset($options[$optskey]) || count($options[$optskey]) == 0 || $refresh )
	{
		$options[$optskey] = mso_get_option($optskey, 'plugins', array());
			
		if( $fn = mso_fe($optsfile, getinfo('plugins_dir').basename(dirname(__FILE__)).'/') ) require($fn);
		if( isset($settings) && count($settings) > 0 )
		{
			foreach( $settings as $key => $opt )
			{
				if( !isset($options[$optskey][$key]) && isset($opt['default']) ) $options[$optskey][$key] = $opt['default'];
			}
		}
	}
		
	return $options[$optskey];
}

# подключаем файл с функцией mso_admin_plugin_options2
if( $fn = mso_fe('mso-admin-plugin-options2.php', getinfo('plugins_dir').basename(dirname(__FILE__)).'/') ) require($fn);

require( getinfo('plugins_dir').basename(dirname(__FILE__)).'/widget.php' ); # подключили файл для виджета
?>