<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * Plugin «Прислать статью» for MaxSite CMS
 * 
 * Author: (c) Илья Земсков (ака Профессор)
 * Plugin URL: http://vizr.ru/page/plugin-submit-article
 */
# читаем опции плагина
$options = submit_article_get_options();
if( count($options) == 0 )
{
	echo false;
	die();
}
	
$CI = & get_instance();
mso_checkreferer();
global $MSO;
	
if( $options['can_upload'] == 1 ) # можно
{
	$folder = preg_replace('/[\/\\\]*$/msi', '', $options['temp_folder']); # убираем слеш в конце строки
	
	if( !is_dir(getinfo('uploads_dir').$folder) ) # Проверка существования папки для закачивания
	{
		@mkdir(getinfo('uploads_dir').$folder, 0777); # пробуем создать
		@mkdir(getinfo('uploads_dir').$folder.'/_mso_i', 0777); 
		@mkdir(getinfo('uploads_dir').$folder.'/mini', 0777);
	}
		
	# Обработка аплоада
	if( !( isset($_REQUEST['_method']) && $_REQUEST['_method'] == 'DELETE' ) && !isset($_REQUEST['_session']) && !isset($_REQUEST['_size']) )
	{
		$msg = '';
			
		# проверка доступного объёма
		if( isset($options['upload_allowed_size']) && $options['upload_allowed_size'] > 0 )
		{
			if( $_FILES['attach']['size'] > $options['upload_allowed_size'] )
			{
				$msg = 'Загрузка файла отклонена - размер файла ('.$_FILES['attach']['size'].') превышает лимит объёма ('.$options['upload_allowed_size'].' байт) для загрузки файлов';
			}
			else
			{
				$uploaded = glob(getinfo('uploads_dir').$folder.'/*.'.$MSO->data['session']['session_id']);
				$uplsize = 0;
				$uplcount = 0;
				foreach( $uploaded as $filename )
				{
					$filename = preg_replace('/\.'.$MSO->data['session']['session_id'].'/msi', '', $filename);
					if( is_file($filename) )
					{
						$uplsize += filesize($filename);
						$uplcount++;
					}
				}
				if( $uplsize > $options['upload_allowed_size'] )
				{
					$msg = 'Загрузка файла отклонена - лимит объёма ('.$options['upload_allowed_size'].' байт) для загрузки файлов исчерпан, т.к. ранее вы загрузили '.$uplcount.' файл(-ов) на '.$uplsize.' байт.';
				}
				if( !$msg && ($newsize = $uplsize + $_FILES['attach']['size']) > $options['upload_allowed_size'] )
				{
					$msg = 'Загрузка файла отклонена - иначе лимит объёма ('.$options['upload_allowed_size'].' байт) для загрузки файлов будет исчерпан, т.к. ранее вы загрузили '.$uplcount.' файл(-ов) на '.$uplsize.' байт.';
				}
			}
		}
	
		if( !$msg )
		{
			require_once( getinfo('common_dir').'uploads.php' ); // функции загрузки 
				
			// параметры для mso_upload
			// конфиг CI-библиотеки upload
			$mso_upload_ar1 = array( 
					'upload_path' => getinfo('uploads_dir').$folder,
					'allowed_types' => $options['upload_allowed_types'],
					'overwrite' => false, #true,
				);
				
			$mso_upload_ar2 = array( // массив прочих опций
					'userfile_title' => '', // описание файла
					'fn_mso_descritions' => getinfo('uploads_dir').$folder.'/_mso_i/_mso_descriptions.dat', // файл для описаний
					'userfile_resize' => false, // нужно ли менять размер
					'userfile_water' => false, // нужен ли водяной знак
					'userfile_mini' => false, // делать миниатюру?
					'prev_size' => ( isset($options['upload_preview_width']) && $options['upload_preview_width'] > 0 ) ? $options['upload_preview_width'] : NULL , #  задаём размер превьюшки
					'message1' => '', // не выводить сообщение о загрузке каждого файла
					// 'message2' => '',
				);
			
			if( isset($options['upload_resize']) && $options['upload_resize'] )
			{
				$mso_upload_ar2['userfile_resize'] = true;
				$mso_upload_ar2['userfile_resize_size'] = ( isset($options['upload_resize_images']) && $options['upload_resize_images'] <> '' ) ? $options['upload_resize_images'] : mso_get_option('resize_images', 'general', '600');
			}
				
			if( isset($options['upload_image_mini']) && $options['upload_image_mini'] )
			{
				$mso_upload_ar2['userfile_mini'] = true;
				$mso_upload_ar2['userfile_mini_size'] = ( isset($options['upload_size_image_mini']) && $options['upload_size_image_mini'] <> '' ) ? $options['upload_size_image_mini'] : mso_get_option('size_image_mini', 'general', '600');
				$mso_upload_ar2['mini_type'] = ( isset($options['upload_image_mini_type']) && $options['upload_image_mini_type'] <> '' ) ? $options['upload_image_mini_type'] : mso_get_option('image_mini_type', 'general', '1');
			}
				
			if( isset($options['upload_use_watermark']) && $options['upload_use_watermark'] )
			{
				$mso_upload_ar2['userfile_water'] = true;
				$mso_upload_ar2['water_type'] = ( isset($options['upload_watermark_type']) && $options['upload_watermark_type'] <> '' ) ? $options['upload_watermark_type'] : mso_get_option('watermark_type', 'general', '1');
				
				$water_file = getinfo('plugins_dir').basename(dirname(__FILE__)).'/images/'.'watermark.png';
				if( file_exists($water_file) )
				{
					$mso_upload_ar2['userfile_water_file'] = $water_file;
				}
				else
				{
					$water_file = getinfo('uploads_dir').'watermark.png';
					if( file_exists($water_file) )
					{
						$mso_upload_ar2['userfile_water_file'] = $water_file;
					}
					else
					{
						$mso_upload_ar2['userfile_water_file'] = false;
					}
				}
			}
				
			ob_start();
			$res = mso_upload($mso_upload_ar1, 'attach', $mso_upload_ar2);
			$msg = ob_get_contents();
			ob_end_clean();
		}
			
		if( !$msg && $res )
		{
			$up_data = $CI->upload->data();
			
			# формирование ответа при загрузке нового файла
			$out = array(
							'name'	=> $up_data['file_name'], # $_FILES['attach']['name'],
							'size'	=> $up_data['file_size'], # $_FILES['attach']['size'],
							'type'	=> $up_data['file_type'], # $_FILES['attach']['type'],
							'deleteUrl'	=> getinfo('site_url').basename(dirname(__FILE__)).'/upload?file='.$up_data['file_name'].'&_method=DELETE', # $_FILES['attach']['name']
							'deleteType'=> "POST",
							'deleteWithCredentials'	=> true,
						);
						
			if( isset($options['upload_preview_width']) && $options['upload_preview_width'] > 0 )
			{
				if( preg_match('/image\//', $up_data['file_type']) )
				{
					$out['preview'] = getinfo('uploads_url').$folder.'/_mso_i/'.$up_data['file_name'];
				}
				else
				{
					$out['preview'] = getinfo('plugins_url').basename(dirname(__FILE__)).'/images/'.'other.png';
				}
			}
				
			if( isset($options['upload_res_path_type']) && $options['upload_res_path_type'] == '1' )
			{
				$out['url'] = getinfo('uploads_url').$folder.'/'.$up_data['file_name']; # $_FILES['attach']['name'];
			}
			else
			{
				$out['url'] = '/uploads/'.$folder.'/'.$up_data['file_name']; # $_FILES['attach']['name'];
			}
				
			# создаём файл с идентификатором сессии
			touch( getinfo('uploads_dir').$folder.'/'.$up_data['file_name'].'.'.$MSO->data['session']['session_id'] ); # $_FILES['attach']['name'] 
		}
		else
		{
			# Ошибка загрузки файла
			$out = array(
							'name'	=> $_FILES['attach']['name'],
							'size'	=> $_FILES['attach']['size'],
							'type'	=> $_FILES['attach']['type'],
							'error'	=> strip_tags($msg),
						);
		}
		$res = array('attach' => array($out));
	}
	elseif( isset($_REQUEST['_method']) && $_REQUEST['_method'] == 'DELETE' )
	{	# удаление файла
		$admin = isset($MSO->data['session']['users_groups_id']) && $MSO->data['session']['users_groups_id'] == 1 ? true : false;
			
		$file_name = mso_clean_str($_REQUEST['file'], 'base');
			
		# проверяем доступ к папке ранее сохранённого материала
		$saved = false;
		$file_folder = mso_clean_str($_REQUEST['folder'], 'base');
		if( $file_folder <> '' )
		{
			$file_go = getinfo('uploads_dir').$file_folder.'/'.$file_name;
			$path_parts = explode('/', $file_folder);
			$pid = isset($path_parts[1]) ? $path_parts[1] : '';
			if( $pid <> '' )
			{
				$comuser = false;
					
				$CI->db->from('meta');
				$CI->db->where('meta_table', 'page');
				$CI->db->where('meta_id_obj', $pid);
				$CI->db->where('meta_key', 'comusers_id');
				$CI->db->where('meta_value', getinfo('comusers_id'));
				$qry = $CI->db->get();
					
				if( $qry->num_rows() > 0 )
				{
					$comuser = true;
				}
					
				if( file_exists($file_go) && ( $admin || ( $comuser && $options['can_edit_saved'] ) ) )
				{
					$folder = $file_folder;
					$saved = true;
				}
			}
		}
			
		$file_path = getinfo('uploads_dir').$folder.'/'.$file_name;
		$file_icon_path = getinfo('uploads_dir').$folder.'/_mso_i/'.$file_name;
		$file_mini_path = getinfo('uploads_dir').$folder.'/mini/'.$file_name;
		$file_sess = $file_path.'.'.$MSO->data['session']['session_id'];
			
		if( is_file($file_sess) && !$saved )
		{
			$success = is_file($file_path) && $file_name[0] !== '.' && unlink($file_path) && unlink($file_sess);
			if( $success )
			{
				if( file_exists($file_icon_path) )
				{
					unlink($file_icon_path);
				}
				if( file_exists($file_mini_path) )
				{
					unlink($file_mini_path);
				}
				$res = array('success' => $success);
			}
			else
			{
				$res = array('error' => 'Произошла ошибка во время удаления файла! Операция не выполнена.');
			}
		}
		else
		{
			if( $saved )
			{
				$success = is_file($file_path) && $file_name[0] !== '.' && unlink($file_path);
				if( $success )
				{
					if( file_exists($file_icon_path) )
					{
						unlink($file_icon_path);
					}
					if( file_exists($file_mini_path) )
					{
						unlink($file_mini_path);
					}
					$res = array('success' => $success);
				}
				else
				{
					$res = array('error' => 'Произошла ошибка во время удаления файла! Операция не выполнена.');
				}
				
			}
			else
			{
				$res = array('error' => 'Такой файл в данной сессии не найден! Операция отклонена.');
			}
		}
	}
	elseif( isset($_REQUEST['_session']) )
	{
		if( $MSO->data['session']['session_id'] == $_REQUEST['_session'] && touch(getinfo('uploads_dir').$folder.'/'.$MSO->data['session']['session_id'].".sessid") )
		{
			# Время модификации файла маркера сессий было изменено на текущее
			$res = array('success' => true);
		}
		else
		{
			$res = array('error' => 'Произошла ошибка во время проверки сессии!');
		}
			
		require( getinfo('plugins_dir').'submit_article/clean.php' ); # подключили файл для чистки мусора
	}
	elseif( isset($_REQUEST['_size']) && $_REQUEST['_size'] == "update" )
	{
		if( isset($options['upload_allowed_size']) && $options['upload_allowed_size'] > 0 )
		{
			$tmpfolder = preg_replace('/[\/\\\]*$/msi', '', $options['temp_folder']); # убираем слеш в конце строки
				
			$uploaded = glob(getinfo('uploads_dir').$tmpfolder.'/*.'.$MSO->data['session']['session_id']);
			$uplsize = 0;
			foreach( $uploaded as $filename )
			{
				$filename = preg_replace('/\.'.$MSO->data['session']['session_id'].'/msi', '', $filename);
				if( is_file($filename) )
				{
					$uplsize += filesize($filename);
				}
			}
				
			$res = array('size' => ($options['upload_allowed_size'] - $uplsize));
		}
		else
		{
			$res = array('error' => 'Нет необходимости проверять лимит, т.к. ограничений на загрузку файлов нет!');
		}
	}
		
	json_response( $res );
}
	
die();
	
###	
function json_response( $resp )
{
	header('Content-type: application/json');
	header('Pragma: no-cache');
	header('Cache-Control: no-store, no-cache, must-revalidate');
	header('Content-Disposition: inline; filename="attach.json"');
	header('X-Content-Type-Options: nosniff');        // Prevent Internet Explorer from MIME-sniffing the content-type:
		
	echo json_encode($resp);
}
?>